<?php

class Stok extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('Model_bahan');
        $this->load->model('Model_kategori');
        $this->load->model('Model_stokbahan');
    }


    function index()
    {
        $data['stokbahan'] = $this->Model_stokbahan->tampil_data();
        $this->template->load('template/template', 'stokbahan/lihat_data', $data);
        $this->load->view('template/datatables');
    }

    function post()
    {
        if (isset($_POST["submit"])) {
            $bahan = $this->input->post('bahan');
            $stokbahan = $this->Model_stokbahan->get_stokbahan($bahan);
            if ($stokbahan != NULL) {
                $stokbahan_sebelumnya = $this->Model_stokbahan->get_stokbahan($bahan)->stokbahan_bahan;
                $stokbahan_baru = $this->input->post('stokbahan');
                $hasil = intval($stokbahan_sebelumnya) + intval($stokbahan_baru);
                if ($hasil >= 100) {
                    $this->session->set_flashdata('message', 'Kapasitas Stok Bahan Telah melebihi Batas Maksimum!');
                    redirect('stokbahan');
                } else {
                    $data = array(
                        'id_bahan' => $bahan,
                        'stokbahan_bahan' => $hasil,
                        'tanggal_stokbahan' => date('Y-m-d')
                    );
                    $this->Model_stokbahan->tambah_stokbahan($bahan, $data);
                    redirect('stokbahan');
                }
            } else {
                $stokbahan = $this->input->post('stokbahan');
                $data = array(
                    'id_bahan' => $bahan,
                    'stokbahan_bahan' => $stokbahan,
                    'tanggal_stokbahan' => date('Y-m-d')
                );
                $this->Model_stokbahan->post($data);
                redirect('stokbahan');
            }
        } else {
            $id = $this->uri->segment(3);
            $data['bahan'] =  $this->Model_bahan->tampil_dropdown()->result();
            $this->template->load("template/template", "stokbahan/form_input", $data);
        }
    }

    function edit()
    {
        if (isset($_POST['submit'])) {
            $id         =   $this->input->post('id');
            $bahan     =   $this->input->post('bahan');
            $stokbahan       =   $this->input->post('stokbahan');
            if (intval($stokbahan) >= 100) {
                $this->session->set_flashdata('message', 'Stok Bahan Yang Dimasukkan Telah melebihi Batas Maksimum!');
                redirect('stokbahan');
            } else {
                $data       =   array(
                    'id_bahan' => $bahan,
                    'stokbahan_bahan' => $stokbahan
                );
                $this->Model_stokbahan->edit($id, $data);
                redirect('stokbahan');
            }
        } else {
            $id =  $this->uri->segment(3);
            $data['bahan'] =  $this->Model_bahan->tampil_dropdown()->result();
            $data['stokbahan']   =  $this->Model_stokbahan->get_one($id)->row_array();
            $this->template->load('template/template', 'Stok/form_edit', $data);
        }
    }

    function hapus()
    {
        $id = $this->uri->segment(3);
        $this->Model_stokbahan->hapus($id);
        redirect('stokbahan');
    }
}
