<?php

class Bahan extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        chek_role();
        $this->load->model('Model_bahan');
        $this->load->model('Model_kategori');
    }
    function index()
    {
        $data['record'] = $this->Model_bahan->tampil_data()->result();
        $this->template->load('template/template', 'bahan/lihat_data', $data);
        $this->load->view('template/datatables');

    }
    function post()
    {
        if (isset($_POST["submit"])) {
            $config['upload_path']          = './uploads/';
            $config['allowed_types']        = 'gif|jpg|png|jpeg';
            $config['max_size']             = 1024;
            $config['max_width']            = 6000;
            $config['max_height']           = 6000;
            $config['overwrite'] = TRUE;
            $config['remove_spaces'] = TRUE;
            $config['encrypt_name'] = TRUE;
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('foto')) {
                $this->session->set_flashdata('message', $this->upload->display_errors());
                redirect($_SERVER['HTTP_REFERER']);
                return false;
            } else {
                // proses bahan
                $id = $this->input->post('id');
                $nama = $this->input->post('nama_bahan');
                $kategori = $this->input->post('kategori');
                $harga = $this->input->post('harga');
                $satuan = $this->input->post('satuan');
                $foto = $this->upload->data('file_name');
                $data = array(
                    'nama_bahan' => $nama,
                    'id_kategori' => $kategori,
                    'satuan' => $satuan,
                    'harga' => $harga,
                    'foto' => $foto,
                );
                $this->Model_bahan->post($data, $id);
                $this->session->set_flashdata('message', 'Data Bahan berhasil ditambahkan!');
                redirect('bahan');
            }
        } else {
            $id = $this->uri->segment(3);
            $data['error'] = $this->upload->display_errors();
            $this->load->model("Model_kategori");
            $data['kategori'] =  $this->Model_kategori->tampilkan_data();
            $data['record'] = $this->Model_bahan->get_one($id)->row_array();
            $data['satuan'] = $this->Model_bahan->tampilkan_satuan()->result();
            $this->template->load("template/template", "bahan/form_input", $data);
        }
    }


    function edit()
    {
        if (isset($_POST['submit'])) {
            $config['upload_path']          = './uploads/';
            $config['allowed_types']        = 'gif|jpg|png|jpeg';
            $config['max_size']             = 1024;
            $config['max_width']            = 6000;
            $config['max_height']           = 6000;
            $config['overwrite'] = TRUE;
            $config['remove_spaces'] = TRUE;
            $config['encrypt_name'] = TRUE;
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('foto')) {
                $this->session->set_flashdata('message', $this->upload->display_errors());
                redirect($_SERVER['HTTP_REFERER']);
                return false;
            } else {
                $id         =   $this->input->post('id');
                $foto = $this->Model_bahan->get_one($id)->row_array()['foto'];
                $path = $this->upload->data('file_path');
                $uploads = $path . $foto;
                if (unlink($uploads)) {
                    echo 'deleted successfully';
                } else {
                    echo 'errors occured';
                }
                $nama       =   $this->input->post('nama_bahan');
                $kategori   =   $this->input->post('kategori');
                $harga      =   $this->input->post('harga');
                $satuan     =   $this->input->post('satuan');
                $foto = $this->upload->data('file_name');
                $data       = array(
                    'nama_bahan' => $nama,
                    'id_kategori' => $kategori,
                    'satuan' => $satuan,
                    'harga' => $harga,
                    'foto' => $foto,
                );
                $this->Model_bahan->edit($data, $id);
                $this->session->set_flashdata('message', 'Data Bahan berhasil dirubah!');
                redirect('bahan');
            }
        } else {
            $id =  $this->uri->segment(3);
            $this->load->model('Model_kategori');
            $data['kategori']   =  $this->Model_kategori->tampilkan_data();
            $data['record']     =  $this->Model_bahan->get_one($id)->row_array();
            $data['satuan'] = $this->Model_bahan->tampilkan_satuan()->result();
            $this->template->load('template/template', 'bahan/form_edit', $data);
        }
    }
    function hapus()
    {
        $id = $this->uri->segment(3);
        $this->Model_bahan->hapus($id);
        $this->session->set_flashdata('message', 'Data Bahan berhasil dihapus!');
        redirect('bahan');
    }

    function detail_modal($id)
    {
        $id = $this->input->get('id');
        $data['detail'] = $this->Model_bahan->get_detail_modal($id);
        $this->load->view('bahan/modal_detail', $data);
    }
}
